/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_ReadOnlyData         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the creation, deletion, modification, opening, closing and usage of a password authenticator object. 
 * And demonstrate the use of transaction with authenticator objects
 *  
 * Algorithm:       
 *    1.  Create a new session by calling: SST_SessionCreate.
 *    2.  Open a transaction by calling: SST_TransactionStart.
 *    3.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
 *    4.  Close the transaction by calling: SST_TransactionEnd. 
 *    5.  Open the new authenticator by calling: SST_AuthenticationOpen.
 *    6.  Open a transaction by calling: SST_TransactionStart.
 *    7.  Insert a new data object by calling: SST_InsertData.
 *    8.    Set the data to read only by calling: SST_DataReadOnlySet
 *    8.  Close the transaction by calling: SST_TransactionEnd.
 *    9.  Read and compare the inserted data by calling: SST_ReadData.
 *    10.  Open a transaction by calling: SST_TransactionStart.
 *    11.  Try to Modify the data from selected location by calling: SST_ModifyData. this should fail!!
 *    12.  Try to delete the data by calling: SST_DeleteData. this should fail!!
 *    13.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    14.  Close the transaction by calling: SST_TransactionClose.
 *    15.  Delete the session by calling: SST_SessionDelete.
 *                            
 ********************************************************************************/    
DxError_t SEPQA_SST_ReadOnlyData ( void );
